<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Equipment extends Model 
{

    protected $table = 'equipments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function reason()
    {
        return $this->hasMany('EquipmentIssue');
    }

    public function equipData()
    {
        return $this->hasMany('OpData');
    }

    public function equipKey()
    {
        return $this->hasMany('OpParams');
    }

}