<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaintenanceInventory extends Model 
{

    protected $table = 'maintenance_inventory';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function runningMaintenance()
    {
        return $this->hasOne('MaintenanceRecords');
    }

    public function inventory()
    {
        return $this->hasMany('Inventory');
    }

}