<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('shift_id')->references('id')->on('shifts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_attendance', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->foreign('process_area_id')->references('id')->on('process_area')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('equipments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipment_issues', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('id')->on('equipments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('maintenance_schedules', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('id')->on('equipments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inventory', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('id')->on('equipments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('op_params', function(Blueprint $table) {
			$table->foreign('equipments_id')->references('id')->on('equipments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('op_data', function(Blueprint $table) {
			$table->foreign('equipments_id')->references('id')->on('equipments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('op_data', function(Blueprint $table) {
			$table->foreign('op_param_id')->references('id')->on('op_params')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('id')->on('equipments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->foreign('reason_id')->references('id')->on('equipment_issues')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('maintenance_schedules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maintenance_inventory', function(Blueprint $table) {
			$table->foreign('maintenance_id')->references('id')->on('maintenance_records')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maintenance_inventory', function(Blueprint $table) {
			$table->foreign('inventory_id')->references('id')->on('inventory')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_request', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leave_request', function(Blueprint $table) {
			$table->foreign('approved_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('allocated_leave', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipment_documents', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('id')->on('equipments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory_vendors', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('inventory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory_vendors', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory_order_documents', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('inventory_order_documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract_documents', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bill_documents', function(Blueprint $table) {
			$table->foreign('bill_id')->references('id')->on('bills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory_orders', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('vendors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inventory_orders', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('inventory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_shift_id_foreign');
		});
		Schema::table('user_attendance', function(Blueprint $table) {
			$table->dropForeign('user_attendance_user_id_foreign');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->dropForeign('equipments_process_area_id_foreign');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->dropForeign('equipments_parent_id_foreign');
		});
		Schema::table('equipment_issues', function(Blueprint $table) {
			$table->dropForeign('equipment_issues_equipment_id_foreign');
		});
		Schema::table('maintenance_schedules', function(Blueprint $table) {
			$table->dropForeign('maintenance_schedules_equipment_id_foreign');
		});
		Schema::table('inventory', function(Blueprint $table) {
			$table->dropForeign('inventory_equipment_id_foreign');
		});
		Schema::table('op_params', function(Blueprint $table) {
			$table->dropForeign('op_params_equipments_id_foreign');
		});
		Schema::table('op_data', function(Blueprint $table) {
			$table->dropForeign('op_data_equipments_id_foreign');
		});
		Schema::table('op_data', function(Blueprint $table) {
			$table->dropForeign('op_data_op_param_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_user_id_foreign');
		});
		Schema::table('bills', function(Blueprint $table) {
			$table->dropForeign('bills_user_id_foreign');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->dropForeign('maintenance_records_equipment_id_foreign');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->dropForeign('maintenance_records_reason_id_foreign');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->dropForeign('maintenance_records_user_id_foreign');
		});
		Schema::table('maintenance_records', function(Blueprint $table) {
			$table->dropForeign('maintenance_records_schedule_id_foreign');
		});
		Schema::table('maintenance_inventory', function(Blueprint $table) {
			$table->dropForeign('maintenance_inventory_maintenance_id_foreign');
		});
		Schema::table('maintenance_inventory', function(Blueprint $table) {
			$table->dropForeign('maintenance_inventory_inventory_id_foreign');
		});
		Schema::table('leave_request', function(Blueprint $table) {
			$table->dropForeign('leave_request_user_id_foreign');
		});
		Schema::table('leave_request', function(Blueprint $table) {
			$table->dropForeign('leave_request_approved_by_foreign');
		});
		Schema::table('allocated_leave', function(Blueprint $table) {
			$table->dropForeign('allocated_leave_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_role_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_role_id_foreign');
		});
		Schema::table('role_permissions', function(Blueprint $table) {
			$table->dropForeign('role_permissions_permission_id_foreign');
		});
		Schema::table('equipment_documents', function(Blueprint $table) {
			$table->dropForeign('equipment_documents_equipment_id_foreign');
		});
		Schema::table('inventory_vendors', function(Blueprint $table) {
			$table->dropForeign('inventory_vendors_item_id_foreign');
		});
		Schema::table('inventory_vendors', function(Blueprint $table) {
			$table->dropForeign('inventory_vendors_vendor_id_foreign');
		});
		Schema::table('inventory_order_documents', function(Blueprint $table) {
			$table->dropForeign('inventory_order_documents_order_id_foreign');
		});
		Schema::table('contract_documents', function(Blueprint $table) {
			$table->dropForeign('contract_documents_contract_id_foreign');
		});
		Schema::table('bill_documents', function(Blueprint $table) {
			$table->dropForeign('bill_documents_bill_id_foreign');
		});
		Schema::table('inventory_orders', function(Blueprint $table) {
			$table->dropForeign('inventory_orders_vendor_id_foreign');
		});
		Schema::table('inventory_orders', function(Blueprint $table) {
			$table->dropForeign('inventory_orders_item_id_foreign');
		});
	}
}