<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Equipment extends Eloquent {

	protected $table = 'equipments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function reason()
	{
		return $this->hasMany('EquipmentIssue');
	}

	public function equipData()
	{
		return $this->hasMany('OpData');
	}

	public function equipKey()
	{
		return $this->hasMany('OpParams');
	}

}