<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWeighBridgeEntriesTable extends Migration {

	public function up()
	{
		Schema::create('weigh_bridge_entries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->timestamp('date');
			$table->float('gross_wt');
			$table->float('tare_wt');
			$table->float('net_wt');
			$table->string('item_name', 100);
		});
	}

	public function down()
	{
		Schema::drop('weigh_bridge_entries');
	}
}