<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function attendance()
	{
		return $this->hasMany('UserAttendance');
	}

	public function bills()
	{
		return $this->hasMany('Bill');
	}

}