<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaintenanceSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('maintenance_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100)->unique();
			$table->string('frequency', 100);
			$table->string('run_at', 50);
			$table->integer('equipment_id')->unsigned()->nullable();
			$table->string('description', 500);
		});
	}

	public function down()
	{
		Schema::drop('maintenance_schedules');
	}
}