<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leguide_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('leguide_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leguide_category_tag', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('leguide_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leguide_category_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('leguide_tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('leguide_categories', function(Blueprint $table) {
			$table->dropForeign('leguide_categories_parent_id_foreign');
		});
		Schema::table('leguide_category_tag', function(Blueprint $table) {
			$table->dropForeign('leguide_category_tag_category_id_foreign');
		});
		Schema::table('leguide_category_tag', function(Blueprint $table) {
			$table->dropForeign('leguide_category_tag_tag_id_foreign');
		});
	}
}