<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CompositionType extends Model 
{

    protected $table = 'composition_types';
    public $timestamps = false;

    public function materials()
    {
        return $this->hasMany('Material');
    }

    public function materialCategories()
    {
        return $this->hasManyThrough('MaterialCategory', 'MaterialCategoryCompositionType');
    }

    public function unitOfMeasures()
    {
        return $this->belongsToMany('UnitOfMeasure');
    }

}