<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreTable extends Migration {

	public function up()
	{
		Schema::create('store', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('subname', 191);
			$table->integer('rate');
			$table->string('logo', 191);
			$table->integer('min_order_default');
			$table->integer('delivery_by');
			$table->integer('country_category_id')->unsigned();
			$table->integer('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('store');
	}
}