<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppIntroTable extends Migration {

	public function up()
	{
		Schema::create('app_intro', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 191);
			$table->longText('text');
			$table->string('image', 191);
			$table->integer('sort')->default('0');
			$table->timestamps();
			$table->integer('status')->default('0');
			$table->integer('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('app_intro');
	}
}