<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountryTable extends Migration {

	public function up()
	{
		Schema::create('country', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('flag', 191);
			$table->string('zip_code', 191);
			$table->string('code', 191);
			$table->string('currency', 191);
			$table->integer('digits');
			$table->string('timezone');
			$table->float('tax');
			$table->string('pricing_method', 191);
			$table->string('commition', 191);
			$table->integer('commition_type');
			$table->integer('price_per_km');
			$table->integer('min_price');
			$table->integer('status')->default('1');
			$table->integer('by_area');
			$table->integer('sent_orders_drivers');
			$table->integer('drivers_type');
			$table->string('driver_destination', 191);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('country');
	}
}