<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersAddressesTable extends Migration {

	public function up()
	{
		Schema::create('users_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nickname', 191);
			$table->integer('user_id')->unsigned();
			$table->integer('area_id')->unsigned();
			$table->string('address', 191);
			$table->string('phone', 191);
			$table->integer('status')->default('1');
			$table->integer('is_default')->default('0');
			$table->string('latitude', 191);
			$table->string('longitude', 191);
		});
	}

	public function down()
	{
		Schema::drop('users_addresses');
	}
}