<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('status', array('pending', 'ongoing', 'completed'));
			$table->integer('created_by')->unsigned();
			$table->integer('assigned_to')->unsigned();
			$table->enum('priority', array('high', 'medium', 'low'));
			$table->date('completion_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}