<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('email', 191);
			$table->string('password');
			$table->string('photo')->nullable();
			$table->string('email_verified_at');
			$table->string('remember_token');
			$table->boolean('isAdmin');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}