<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->integer('created_by')->unsigned();
			$table->string('manager');
			$table->enum('status', array('pending', 'ongoing', 'completed'));
			$table->string('duration');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}