<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubtasksTable extends Migration {

	public function up()
	{
		Schema::create('subtasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->integer('task_id')->unsigned();
			$table->string('description');
			$table->date('start_date');
			$table->date('end_date');
			$table->enum('priority', array('high', 'medium', 'low'));
			$table->enum('status', array('pending', 'ongoing', 'completed'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subtasks');
	}
}