<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array(''));
			$table->integer('user_id')->unsigned()->index();
			$table->integer('sender_id')->unsigned()->index();
			$table->text('content');
			$table->boolean('seen');
			$table->timestamp('created_at');
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}