<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRateTypesTable extends Migration {

	public function up()
	{
		Schema::create('rate_types', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('status')->nullable()->default(1);
			$table->string('type', 50)->nullable()->default('positive');
			$table->string('for', 50)->nullable()->default('client');
			$table->json('name')->nullable();
			$table->integer('points')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rate_types');
	}
}