<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlertasTable extends Migration {

	public function up()
	{
		Schema::create('alertas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('plataforma_id')->unsigned();
			$table->string('titulo');
			$table->timestamps();
			$table->text('template');
			$table->string('link', 255);
			$table->boolean('activo')->default(1);
			$table->timestamp('utimo_proceso');
			$table->integer('identidad_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('alertas');
	}
}