<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMensajesTable extends Migration {

	public function up()
	{
		Schema::create('mensajes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('plataforma_id')->unsigned();
			$table->integer('emisor_id')->unsigned()->nullable();
			$table->string('asunto', 255);
			$table->text('cuerpo');
			$table->boolean('borrado')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('mensajes');
	}
}