<?php

class Mensaje extends Eloquent {

	protected $table = 'mensajes';
	public $timestamps = true;
	protected $fillable = array('emisor_id');

	public function emisor()
	{
		return $this->belongsTo('Identidad', 'emisor_id');
	}

	public function envios()
	{
		return $this->hasMany('Envio');
	}

	public function adjuntos()
	{
		return $this->hasMany('Adjunto', 'mensaje_id');
	}

	public function plataforma()
	{
		return $this->belongsTo('Plataforma');
	}

}