<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFncDepensesTable extends Migration {

	public function up()
	{
		Schema::create('fnc_depenses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_enseignant')->unsigned();
			$table->timestamps();
			$table->text('libelle');
			$table->integer('montant');
			$table->date('date');
			$table->string('annee_academique', 255);
			$table->string('nom_table_indexe', 255);
			$table->boolean('etat')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('fnc_depenses');
	}
}