<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Categorie extends Model 
{

    protected $table = 'categorie';
    public $timestamps = true;
    protected $fillable = array('nom_categorie', 'etat', 'annee_academique');
    protected $visible = array('nom_categorie', 'etat', 'annee_academique');

    public function administrateur()
    {
        return $this->hasMany('App\Administrateur', 'id_categorie');
    }

    public function tuteur()
    {
        return $this->hasMany('App\Tuteur', 'id_categorie');
    }

    public function eleve()
    {
        return $this->hasMany('App\Eleve', 'id_categorie');
    }

    public function identifiant()
    {
        return $this->hasMany('App\Identifiant', 'id_categorie');
    }

    public function droit()
    {
        return $this->hasMany('App\Droit', 'id_categorie');
    }

    public function categories_annee()
    {
        return $this->hasMany('App\Categorie_annee', 'id_categorie');
    }

}