<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Eleve extends Model 
{

    protected $table = 'eleves';
    public $timestamps = true;
    protected $fillable = array('id_categorie', 'id_tuteur', 'statut', 'etat', 'matricule', 'annee_academique');
    protected $visible = array('id_categorie', 'id_tuteur', 'statut', 'etat', 'matricule', 'annee_academique');

    public function categorie()
    {
        return $this->belongsTo('App\Categorie', 'id_categorie');
    }

    public function tuteur()
    {
        return $this->belongsTo('App\Tuteur', 'id_tuteur');
    }

    public function faire_classe()
    {
        return $this->hasMany('App\Faire_classe', 'id_eleve');
    }

    public function participe()
    {
        return $this->hasMany('App\Participe', 'id_eleve');
    }

    public function evaluation1()
    {
        return $this->hasMany('App\Evaluation1', 'id_eleve');
    }

    public function evaluation2()
    {
        return $this->hasMany('App\Evaluation2', 'id_eleve');
    }

    public function evaluation3()
    {
        return $this->hasMany('App\Evaluation3', 'id_eleve');
    }

    public function evaluation4()
    {
        return $this->hasMany('App\Evaluation4', 'id_eleve');
    }

    public function evaluation5()
    {
        return $this->hasMany('App\Evaluation5', 'id_eleve');
    }

    public function evaluation6()
    {
        return $this->hasMany('App\Evaluation6', 'id_eleve');
    }

    public function evaluation7()
    {
        return $this->hasMany('App\Evaluation7', 'id_eleve');
    }

    public function evaluation8()
    {
        return $this->hasMany('App\Evaluation8', 'id_eleve');
    }

    public function evaluation9()
    {
        return $this->hasMany('App\Evaluation9', 'id_eleve');
    }

    public function evaluation10()
    {
        return $this->hasMany('App\Evaluation10', 'id_eleve');
    }

    public function evaluation11()
    {
        return $this->hasMany('App\Evaluation11', 'id_eleve');
    }

    public function evaluation12()
    {
        return $this->hasMany('App\Evaluation12', 'id_eleve');
    }

    public function identifiant()
    {
        return $this->hasMany('App\Identifiant', 'id_utilisateur');
    }

    public function fnc_transaction()
    {
        return $this->hasMany('Modules\Finance\Entities\Fnc_transaction', 'id_eleve');
    }

}