<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Enseignant extends Model 
{

    protected $table = 'enseignants';
    public $timestamps = true;
    protected $fillable = array('id_categorie', 'etat', 'matricule', 'annee_academique');
    protected $visible = array('id_categorie', 'etat', 'matricule', 'annee_academique');

    public function categorie_annee()
    {
        return $this->hasMany('App\Categorie_annee', 'id_categorie');
    }

    public function dispense()
    {
        return $this->hasMany('App\Dispense', 'id_enseignant');
    }

    public function identifiant()
    {
        return $this->hasMany('App\Identifiant', 'id_utilisateur');
    }

    public function info_classe()
    {
        return $this->hasMany('App\Info_classe', 'id_enseignant_titulaire');
    }

    public function depense()
    {
        return $this->hasMany('Modules\Finance\Entities\Fnc_depense', 'id_enseignant');
    }

    public function transaction()
    {
        return $this->hasMany('Modules\Finance\Entities\Fnc_transaction', 'id_enseignant');
    }

}