<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Evaluation1 extends Model 
{

    protected $table = 'evaluation1';
    public $timestamps = true;
    protected $fillable = array('id_eleve', 'id_classe', 'id_enseignant', 'id_matiere', 'id_participe', 'note', 'coefficient', 'annee_academique', 'date_evaluation', 'etat');
    protected $visible = array('id_eleve', 'id_classe', 'id_enseignant', 'id_matiere', 'id_participe', 'note', 'coefficient', 'annee_academique', 'date_evaluation', 'etat');

    public function participe()
    {
        return $this->belongsTo('App\Participe', 'id_participe');
    }

    public function matiere()
    {
        return $this->belongsTo('App\Matiere', 'id_matiere');
    }

    public function eleve()
    {
        return $this->belongsTo('App\Eleve', 'id_eleve');
    }

    public function classe()
    {
        return $this->belongsTo('App\Classe', 'id_classe');
    }

}