<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSanctionsTable extends Migration {

	public function up()
	{
		Schema::create('sanctions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_faire_classe')->unsigned();
			$table->string('cause', 255);
			$table->string('libele', 255);
			$table->date('date_sanction');
			$table->boolean('etat')->nullable()->default(0);
			$table->string('annee_academique', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sanctions');
	}
}