<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Categorie_annee extends Model 
{

    protected $table = 'categories_annee';
    public $timestamps = true;
    protected $fillable = array('id_categorie', 'id_enseignant', 'id_etablissement', 'annee_academique', 'etat');
    protected $visible = array('id_categorie', 'id_enseignant', 'id_etablissement', 'annee_academique', 'etat');

    public function enseignant()
    {
        return $this->belongsTo('App\Enseignant', 'id_enseignant');
    }

    public function categirie()
    {
        return $this->belongsTo('App\Categorie', 'id_categorie');
    }

    public function etabissement()
    {
        return $this->belongsTo('App\Etablissement', 'id_etabissement');
    }

}