<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBulletinsTable extends Migration {

	public function up()
	{
		Schema::create('bulletins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_faire_classe')->unsigned();
			$table->integer('heure_abcence')->nullable();
			$table->string('blame', 255)->nullable();
			$table->string('periode', 255);
			$table->boolean('etat')->nullable()->default(0);
			$table->decimal('moyenne');
			$table->string('annee_academique', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bulletins');
	}
}