<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClassesTable extends Migration {

	public function up()
	{
		Schema::create('classes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_serie')->unsigned()->nullable();
			$table->integer('id_classe_mere')->unsigned();
			$table->string('nom', 255);
			$table->boolean('etat')->default(0);
			$table->string('annee_academique', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('classes');
	}
}