<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDispensesTable extends Migration {

	public function up()
	{
		Schema::create('dispenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_enseignant')->unsigned();
			$table->integer('id_matiere')->unsigned();
			$table->integer('id_classe')->unsigned();
			$table->string('annee_academique', 255)->nullable();
			$table->integer('coefficient');
			$table->datetime('prise_fonction_date');
			$table->boolean('etat')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('dispenses');
	}
}