<?php

namespace App;

class Evaluation2 extends Eloquent {

	protected $table = 'evaluation2';
	public $timestamps = true;
	protected $fillable = array('id_participe', 'id_eleve', 'id_classe', 'note', 'coefficient', 'id_matiere', 'annee_academique', 'id_enseignant', 'date_evaluation', 'etat');
	protected $visible = array('id_participe', 'id_eleve', 'id_classe', 'note', 'coefficient', 'id_matiere', 'annee_academique', 'id_enseignant', 'date_evaluation', 'etat');

	public function participe()
	{
		return $this->belongsTo('App\Participe', 'iid_participe');
	}

	public function matiere()
	{
		return $this->belongsTo('App\Matiere', 'id_matiere');
	}

	public function classe()
	{
		return $this->belongsTo('App\Classe', 'id_classe');
	}

	public function eleve()
	{
		return $this->belongsTo('App\Eleve', 'id_eleve');
	}

}