<?php

namespace App;

class Evaluation3 extends Eloquent {

	protected $table = 'evaluation3';
	public $timestamps = true;
	protected $fillable = array('id_participe', 'id_eleve', 'id_matiere', 'id_classe', 'note', 'coefficient', 'annee_academique', 'id_enseignant', 'date_evaluation', 'etat');
	protected $visible = array('id_participe', 'id_eleve', 'id_matiere', 'id_classe', 'note', 'coefficient', 'annee_academique', 'id_enseignant', 'date_evaluation', 'etat');

	public function participe()
	{
		return $this->belongsTo('App\Participe', 'id_participe');
	}

	public function eleve()
	{
		return $this->belongsTo('App\Eleve', 'id_eleve');
	}

	public function matiere()
	{
		return $this->belongsTo('App\Matiere', 'id_matiere');
	}

	public function classe()
	{
		return $this->belongsTo('App\Classe', 'id_classe');
	}

}