<?php

namespace App;

class Tuteur extends Eloquent {

	protected $table = 'tuteurs';
	public $timestamps = true;
	protected $fillable = array('id_categorie', 'etat', 'annee_academique');
	protected $visible = array('id_categorie', 'etat', 'annee_academique');

	public function categorie()
	{
		return $this->belongsTo('App\Categorie', 'id_categorie');
	}

	public function eleve()
	{
		return $this->hasMany('App\Eleve', 'id_tuteur');
	}

	public function identifiant()
	{
		return $this->hasMany('App\Identifiant', 'id_utilisateur');
	}

}