<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIdentifiantsTable extends Migration {

	public function up()
	{
		Schema::create('identifiants', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_categorie')->unsigned();
			$table->integer('id_utilisateur')->nullable();
			$table->timestamps();
			$table->string('prenom', 255);
			$table->string('nom', 255);
			$table->timestamp('date_naissance')->nullable();
			$table->string('lieu_naissance', 255)->nullable();
			$table->string('photo', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('telephone', 255)->nullable();
			$table->string('login', 255)->unique()->nullable();
			$table->string('mot_pass', 255)->nullable();
			$table->string('nom_table_indexe', 255);
			$table->boolean('etat')->default(0);
			$table->string('commentaire_etat', 255)->nullable();
			$table->timestamp('date_etat')->nullable();
			$table->string('annee_academique', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('identifiants');
	}
}