<?php

namespace App;

class Administrateur extends Eloquent {

	protected $table = 'administrateurs';
	public $timestamps = true;
	protected $fillable = array('id_categorie', 'etat', 'annee_academique');
	protected $visible = array('id_categorie', 'etat', 'annee_academique');

	public function categorie()
	{
		return $this->belongsTo('App\Categorie', 'id_categorie');
	}

	public function identifiant()
	{
		return $this->hasMany('App\Identifiant', 'id_utilisateur');
	}

	public function depense()
	{
		return $this->hasMany('Modules\Finance\Entities\Fnc_depense', 'id_enseignant');
	}

	public function transaction()
	{
		return $this->hasMany('Modules\Finance\Entities\Fnc_transaction', 'id_enseignant');
	}

}