<?php

namespace App;

class Dispense extends Eloquent {

	protected $table = 'dispenses';
	public $timestamps = true;
	protected $fillable = array('id_enseignant', 'id_matiere', 'id_classe', 'annee_academique', 'coefficient', 'prise_fonction_date', 'etat');
	protected $visible = array('id_enseignant', 'id_matiere', 'id_classe', 'annee_academique', 'coefficient', 'prise_fonction_date', 'etat');

	public function matiere()
	{
		return $this->belongsTo('App\Matiere', 'id_matiere');
	}

	public function enseignant()
	{
		return $this->belongsTo('App\Enseignant', 'id_enseignant');
	}

	public function classe()
	{
		return $this->belongsTo('App\Classe', 'id_classe');
	}

	public function programmation()
	{
		return $this->hasMany('EDT_periode');
	}

}