<?php

namespace App;

class Evaluation8 extends Eloquent {

	protected $table = 'evaluation8';
	public $timestamps = true;
	protected $fillable = array('id_participe', 'id_eleve', 'note', 'id_classe', 'coefficient', 'id_matiere', 'annee_academique', 'id_enseignant', 'date_evaluation', 'etat');
	protected $visible = array('id_eleve', 'note', 'id_classe', 'coefficient', 'id_matiere', 'annee_academique', 'id_enseignant', 'date_evaluation', 'etat');

	public function participe()
	{
		return $this->belongsTo('App\Participe', 'id_participe');
	}

	public function eleve()
	{
		return $this->belongsTo('App\Eleve', 'id_eleve');
	}

	public function classe()
	{
		return $this->belongsTo('App\Classe', 'id_classe');
	}

	public function matiere()
	{
		return $this->belongsTo('App\Matiere', 'id_matiere');
	}

}