<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFncTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('fnc_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_eleve')->unsigned();
			$table->integer('id_type_paiement')->unsigned()->nullable();
			$table->integer('id_enseignant')->unsigned()->nullable();
			$table->integer('montant');
			$table->integer('reste');
			$table->date('date');
			$table->boolean('etat')->default(0);
			$table->string('annee_academique', 255)->nullable();
			$table->string('nom_table_indexe', 255);
		});
	}

	public function down()
	{
		Schema::drop('fnc_transactions');
	}
}