<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChannelsTable extends Migration {

	public function up()
	{
		Schema::create('channels', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team_id')->unsigned();
			$table->string('code', 50)->nullable();
			$table->string('name', 50);
			$table->string('pic_name', 50);
			$table->string('pic_phone', 20);
			$table->string('pic_email', 30);
			$table->text('description')->nullable();
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('channels');
	}
}