<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->integer('status')->default('0');
			$table->integer('role_group_id')->unsigned();
			$table->string('uri', 50);
			$table->integer('is_public')->default('0');
			$table->integer('read')->default('0');
			$table->integer('create')->default('0');
			$table->integer('update')->default('0');
			$table->integer('delete')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}