<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team_id')->unsigned();
			$table->string('code', 15)->nullable();
			$table->string('name', 50);
			$table->string('pic_name', 50);
			$table->string('pic_phone', 20);
			$table->string('pic_email', 30)->nullable();
			$table->text('description');
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}