<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkOrdersTable extends Migration {

	public function up()
	{
		Schema::create('work_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->string('priority', 10);
			$table->integer('asset_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('description')->nullable();
			$table->integer('status_order')->nullable()->default('0');
			$table->integer('status')->default('0');
			$table->date('due_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('work_orders');
	}
}