<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('asset_items', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('asset_categorys')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('asset_categorys')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('asset_items')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('floor_id')->references('id')->on('floors')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('buildings', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('floors', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('floor_id')->references('id')->on('floors')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('channels', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('role_group_id')->references('id')->on('role_groups')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('work_orders', function(Blueprint $table) {
			$table->foreign('asset_id')->references('id')->on('assets')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('work_orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('task_work_orders', function(Blueprint $table) {
			$table->foreign('work_order_id')->references('id')->on('work_orders')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('parts', function(Blueprint $table) {
			$table->foreign('asset_id')->references('id')->on('assets')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_modules', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_modules', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_modules', function(Blueprint $table) {
			$table->foreign('role_group_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('task_parts', function(Blueprint $table) {
			$table->foreign('part_id')->references('id')->on('parts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('task_parts', function(Blueprint $table) {
			$table->foreign('task_work_id')->references('id')->on('task_work_orders')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('comment_wos', function(Blueprint $table) {
			$table->foreign('work_order_id')->references('id')->on('work_orders')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('comment_wos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('asset_items', function(Blueprint $table) {
			$table->dropForeign('asset_items_category_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_team_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_category_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_item_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_building_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_floor_id_foreign');
		});
		Schema::table('assets', function(Blueprint $table) {
			$table->dropForeign('assets_room_id_foreign');
		});
		Schema::table('buildings', function(Blueprint $table) {
			$table->dropForeign('buildings_team_id_foreign');
		});
		Schema::table('floors', function(Blueprint $table) {
			$table->dropForeign('floors_building_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_floor_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_team_id_foreign');
		});
		Schema::table('channels', function(Blueprint $table) {
			$table->dropForeign('channels_team_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_channel_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_service_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_team_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_role_group_id_foreign');
		});
		Schema::table('work_orders', function(Blueprint $table) {
			$table->dropForeign('work_orders_asset_id_foreign');
		});
		Schema::table('work_orders', function(Blueprint $table) {
			$table->dropForeign('work_orders_user_id_foreign');
		});
		Schema::table('task_work_orders', function(Blueprint $table) {
			$table->dropForeign('task_work_orders_work_order_id_foreign');
		});
		Schema::table('parts', function(Blueprint $table) {
			$table->dropForeign('parts_asset_id_foreign');
		});
		Schema::table('user_modules', function(Blueprint $table) {
			$table->dropForeign('user_modules_user_id_foreign');
		});
		Schema::table('user_modules', function(Blueprint $table) {
			$table->dropForeign('user_modules_module_id_foreign');
		});
		Schema::table('user_modules', function(Blueprint $table) {
			$table->dropForeign('user_modules_role_group_id_foreign');
		});
		Schema::table('task_parts', function(Blueprint $table) {
			$table->dropForeign('task_parts_part_id_foreign');
		});
		Schema::table('task_parts', function(Blueprint $table) {
			$table->dropForeign('task_parts_task_work_id_foreign');
		});
		Schema::table('comment_wos', function(Blueprint $table) {
			$table->dropForeign('comment_wos_work_order_id_foreign');
		});
		Schema::table('comment_wos', function(Blueprint $table) {
			$table->dropForeign('comment_wos_user_id_foreign');
		});
	}
}