<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LabReport extends Model 
{

    protected $table = 'lab_reports';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('patient_id', 'doctor_id', 'date', 'details');

    public function doctor()
    {
        return $this->belongsTo('Models\Doctor', 'doctor_id');
    }

    public function patient()
    {
        return $this->belongsTo('Models\Patient', 'patient_id');
    }

}