<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionItemsTable extends Migration {

	public function up()
	{
		Schema::create('prescription_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('prescription_id')->nullable();
			$table->integer('item_id')->nullable();
			$table->string('item_type')->nullable();
			$table->longText('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('prescription_items');
	}
}