<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Holiday extends Model 
{

    protected $table = 'holidays';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('doctor_id', 'day', 'notes');

    public function doctor()
    {
        return $this->belongsTo('Models\Doctor', 'doctor_id');
    }

}