<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Department extends Eloquent {

	protected $table = 'departments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function doctors()
	{
		return $this->hasMany('Models\Doctor', 'department_id');
	}

}