<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('patient_id', 'doctor_id', 'discount', 'discount_type', 'total', 'total_after_discount', 'notes', 'paid_amount');

	public function items()
	{
		return $this->hasMany('Models\InvoiceItem', 'invoice_id');
	}

	public function docto()
	{
		return $this->belongsTo('Models\Doctor', 'doctor_id');
	}

	public function patient()
	{
		return $this->belongsTo('Models\Patient', 'patient_id');
	}

	public function reference()
	{
		return $this->belongsTo('Models\Refrence', 'reference');
	}

}